//bdshome.jds


//Module Variables
var fileSystemObject = new ActiveXObject("Scripting.FileSystemObject");

//Action Functions
function openProject()
{
  external.Application.MainForm.FileOpenProjectItem.Click;
}

function newProject()
{
  external.Application.MainForm.FileNewItem.Click;
}

function openFile()
{
  external.Application.MainForm.FileOpenItem.Click;
}

function newFile()
{
  external.Application.MainForm.SearchFileFindItem.Click;
}

function viewPrjMgrItem()
{
  external.Application.MainForm.ViewPrjMgrItem.Click;
}

function openHelp()
{
  external.Application.MainForm.HelpInprisePage.Click;
}

function openHelpCSTutorial()
{
  external.Application.MainForm.HelpCsTutorialItem.Click;
}

function openDExplore(url)
{
    var session = new ActiveXObject("DExplore.AppObj");
    session.SetCollection("ms-help://borland.bds2","");
    session.Contents();
    session.DisplayTopicFromUrl(url);
    session.SyncContents(url);
}

//file manipulation functions
function ExtractPathedFileFromCaption(FileString)
{
    return FileString.substring(FileString.indexOf(' ')+1, FileString.length);
}

function ExtractValuesFromKeyString(KeyString)
{
  var KeyStringArray = new Array();
  KeyStringArray = KeyString.split(',');
  return KeyStringArray;
}


function ClickMenu(Index)
{
  var MenuItem = external.Application.MainForm.FileClosedFilesItem.GetItems(Index);
  if (MenuItem != null)
    MenuItem.Click;
}

function GetMenuText(Caption, Index)
{
  var Text = "";
  if (Caption != "-")
  {
    var pick = Caption.substring(1, 2);
    if (pick < "5")
      Text = Caption.substr(3);
  }
  var i = Text.lastIndexOf("\\");
  if (Text.length > 0 && i > 0)
    Text = Text.substr(i + 1);
  if (Text != "")
    Text = "<a class=\"filename\" href=\"default.htm\" onclick=\"ClickMenu(" + Index + ")\">" + Text + "</A><br>";
  return Text;
}

function NumToStr(Value, Pad)
{
  if ( Pad && Value < 10 )
   return "0" + Value;
  else
   return Value;
}

function GetFileModifiedString(PathedFile)
{
 if(fileSystemObject != null)
 {
   if(fileSystemObject.FileExists(PathedFile))
   {
     var fModified = false;
     var objDateFile = new Date(fileSystemObject.GetFile(PathedFile).DateLastModified);
     var dateFormat = "M/d/yy";
     var timeFormat = "h:mm:ss t";
     var dateSeparator = "/";
     var timeSeparator = ":"
     var sAM = "AM";
     var sPM = "PM";

     var formats = dateFormat.split(dateSeparator);
     var date = "";
     for ( var i = 0; i < formats.length; i++ )
     {
       switch ( formats[i] )
       {
         case "yy":     date += NumToStr(objDateFile.getYear() % 100, true); break;
         case "yyyy":   date += NumToStr(objDateFile.getYear(), false); break;
         case "M":      date += NumToStr(objDateFile.getMonth()+1, false); break;
         case "MM":     date += NumToStr(objDateFile.getMonth()+1, true); break;
         case "d":      date += NumToStr(objDateFile.getDate(), false); break;
         case "dd":     date += NumToStr(objDateFile.getDate(), true); break;
       }
       if ( i + 1 < formats.length )
         date += dateSeparator;
     }
     date += " ";
     formats = timeFormat.split(timeSeparator);
     for ( var i = 0; i < formats.length; i++ )
     {
       switch ( formats[i] )
       {
         case "h":      date += NumToStr((objDateFile.getHours() + 11)  % 12 + 1, false); break;
         case "hh":     date += NumToStr((objDateFile.getHours() + 11)  % 12 + 1, true); break;
         case "H":      date += NumToStr(objDateFile.getHours(), false); break;
         case "HH":     date += NumToStr(objDateFile.getHours(), true); break;
         case "mm":     date += NumToStr(objDateFile.getMinutes(), true); break;
         case "mm t":   date += NumToStr(objDateFile.getMinutes(), true) + " " + (objDateFile.getHours() < 12 ? sAM : sPM); break;
         case "ss":     date += NumToStr(objDateFile.getSeconds(), true); break;
         case "ss t":   date += NumToStr(objDateFile.getSeconds(), true) + " " + (objDateFile.getHours() < 12 ? sAM : sPM); break;
       }
       if ( i + 1 < formats.length )
         date += timeSeparator;
     }
     return date;
   }
   else
   {
	 return "File not found";
   }
 }
 else
 {
   return "Unable to read file date";
 }
}

function GetFileExtension(filename)
{
 return filename.substring(filename.lastIndexOf("."));
}

function IsProjectGroup(filename)
{
  var fileExt = GetFileExtension(filename);
  var pattern = /\.bdsgroup/;
  if (pattern.test(fileExt))
  {
    return true;
  }
  else
  {
    return false;
  }
}

function loadXML(url)
{
  if (window.ActiveXObject)
  {
  	var xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
	xmlDoc.async="false";
	xmlDoc.load(url);
	var nodes = xmlDoc.getElementsByTagName("*");
	for (var i = 0; i < nodes.length; i++)
	{

		document.writeln(nodes[i].nodeName);
	}

  }


}


function write(output){
   document.writeln(output);
}

//Render Recent Projects HTML
/*****************************************************************************\
 Module functions
\*****************************************************************************/
function RenderProjectsModule()
{
	var tagOpenTable = " <table width='100%' cellpadding='2' cellspacing=0 > ";
	//var firstCol = "<td width='8' bgcolor='#FFFFFF">&nbsp;</td>";
	var tagOpenTHead = "<thead  >";
	var tagOpenTBody = "<tbody>";
	var tagOpenTH = "<th align=left class='tableheader'>";
	var tagOpenTR = "<tr class='whiterow'>";
	var tagOpenTD = "<td>";
	var tagOpenTRAlt = "<tr class='featuretable'>";
	var tagClsTable = "</table>";
	var tagClsTHead = "</thead>";
	var tagClsTBody = "</tbody>";
	var tagClsTH = "</th>";
	var tagClsTR = "</tr>";
	var tagClsTD = "</td>";
	var FColCnt=3;
	var FRowCnt=6;
	//  Cells Data Matirx [ROW][COL]
	var Cells = new Array();
	var  ReopenMenu = external.Application.MainForm.FileClosedFilesItem;
	// Initialize each array in the array of arrays.
	FRowCnt= ReopenMenu.Count()+1;
	for(var i = 0; i<FRowCnt; i++)
		Cells[i] = new Array(2);

	Cells[0][0]= "Recent Projects";
	Cells[0][1]= "Modified";
	Cells[0][2]= "Type";
	for(var i=1; i<FRowCnt ; i++){
		var MenuItem = ReopenMenu.GetItems(i-1);
		var MenuText = GetMenuText(MenuItem.Caption, MenuItem.MenuItemIndex);
		if (MenuText != "")
		{
			Cells[i][0]= MenuText;
			Cells[i][1]= GetFileModifiedString(ExtractPathedFileFromCaption(MenuItem.Caption));
			if (IsProjectGroup(MenuText))
			{
			  Cells[i][2]= "<center><img src=\"bds:/images/project_group.gif\"></center>";
			}
			else
			{
			  Cells[i][2]= "<center><img src=\"bds:/images/project.gif\"></center>";
			}
		}
		else{
		  FRowCnt=i;
		  break;
		  }
	}
    var alt=false;
    write(tagOpenTable);
    write(tagOpenTHead + tagOpenTR + tagOpenTH);
    write(Cells[0][0] + tagClsTH + tagOpenTH);
    write(Cells[0][1] + tagClsTH + tagOpenTH);
    write(Cells[0][2] + tagClsTH + tagClsTR + tagClsTHead);
    write(tagOpenTBody);
    for(var rc=1; rc<FRowCnt; rc++){
  //    write(tagOpenTR);
      if(alt){
        write(tagOpenTRAlt);
        alt=false;
        }
        else{
          write(tagOpenTR);
          alt=true;
        }
      for(var cc=0; cc<FColCnt; cc++)
        write(tagOpenTD + Cells[rc][cc] + tagClsTD);
      write(tagClsTR);
      if(!alt) write("</div>");
    }
    write(tagClsTBody + tagClsTable);
}

